﻿///
/// アーカイブ形式に関する列挙型を定義するヘッダファイル。
///

#if       !defined(INCLUDED_SZ_ARCHIVE_FORMAT)
#define            INCLUDED_SZ_ARCHIVE_FORMAT

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

SZ_NS_BEG(szpp)

/// <summary>
/// アーカイブ形式を表す列挙型。主にアーカイブを新規作成するときに本列挙型を使ってアーカイブ形式を特定する。
/// </summary>
enum ArchiveFormat
{
  ARCHIVE_FORMAT_NONE     = 0x00,
  ARCHIVE_FORMAT_ZIP      = 0x01,
  ARCHIVE_FORMAT_BZIP2    = 0x02,
  ARCHIVE_FORMAT_RAR      = 0x03,
  ARCHIVE_FORMAT_ARJ      = 0x04,
  ARCHIVE_FORMAT_Z        = 0x05,
  ARCHIVE_FORMAT_LZH      = 0x06,
  ARCHIVE_FORMAT_7Z       = 0x07,
  ARCHIVE_FORMAT_CAB      = 0x08,
  ARCHIVE_FORMAT_NSIS     = 0x09,
  ARCHIVE_FORMAT_LZMA     = 0x0A,
  ARCHIVE_FORMAT_LZMA86   = 0x0B,
  ARCHIVE_FORMAT_XZ       = 0x0C,

  ARCHIVE_FORMAT_NTFS     = 0xD9,
  ARCHIVE_FORMAT_FAT      = 0xDA,
  ARCHIVE_FORMAT_MBR      = 0xDB,
  ARCHIVE_FORMAT_VHD      = 0xDC,
  ARCHIVE_FORMAT_PE       = 0xDD,
  ARCHIVE_FORMAT_ELF      = 0xDE,
  ARCHIVE_FORMAT_MACH_O   = 0xDF,
  ARCHIVE_FORMAT_UDF      = 0xE0,
  ARCHIVE_FORMAT_XAR      = 0xE1,
  ARCHIVE_FORMAT_MUB      = 0xE2,
  ARCHIVE_FORMAT_HFS      = 0xE3,
  ARCHIVE_FORMAT_DMG      = 0xE4,
  ARCHIVE_FORMAT_COMPOUND = 0xE5,
  ARCHIVE_FORMAT_WIM      = 0xE6,
  ARCHIVE_FORMAT_ISO      = 0xE7,
  ARCHIVE_FORMAT_BKF      = 0xE8,
  ARCHIVE_FORMAT_CHM      = 0xE9,
  ARCHIVE_FORMAT_SPLIT    = 0xEA,
  ARCHIVE_FORMAT_RPM      = 0xEB,
  ARCHIVE_FORMAT_DEB      = 0xEC,
  ARCHIVE_FORMAT_CPIO     = 0xED,
  ARCHIVE_FORMAT_TAR      = 0xEE,
  ARCHIVE_FORMAT_GZIP     = 0xEF,
};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_FORMAT)
